/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : POSITIVE EDGE TRIGGERED JKB FLIP-FLOP WITH CLEAR & PRESET 
TRUTHTABLE     : 

            --------------------------------
            J   K_  CLK CLR_  PRE_  Q   Q_
            -------------------------------- 
                     _            
            L   L  _/    H    H     L   H
                     _            
            L   H  _/    H    H     Q  Q_
                     _            
            H   L  _/    H    H     Q_ Q
                     _            
            H   H  _/    H    H     H   L

            X   X   X     L    H     L   H
                                  
            X   X   X     H    L     H   L
                                  
            X   X   X     L    L     H   H
            -------------------------------- 

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : June 1994 

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a109 (clrn, j, kn, clk, pren, q, qn);
	parameter size =1;
	input
		clrn,
		j,
		kn,
		clk,
		pren;
	output
		q,
		qn;


    reg
        NOTIFY_REG;
    and
	  (enable1, pren, clrn);

    not
	  (m109_inst1_nk1b, kn);
    U_FJK_P_SB_RB_NO  
	M109_inst1_inst1_inst1 (q, j, m109_inst1_nk1b, dd_net5, dd_net3, pren, NOTIFY_REG);
    and
	M109_inst1_inst1_A1 (m109_inst1_inst1_enable, clrn, pren);
    U_FJK_P_SB_RB_NO_QN  
	M109_inst1_inst2_inst2 (qn, j, m109_inst1_nk1b, clk, clrn, pren, NOTIFY_REG);
    and
	M109_inst1_inst2_A1 (m109_inst1_inst2_enable, clrn, pren);

    buf  
	  (dd_net3, clrn);
    buf  
	  (dd_net5, clk);





    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
